#38_animation_fadenpendel.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Daten
l = 1.0        #Pendellänge in m
winkel = 60    #Auslenkwinkel
d = 0.0        #Dämpfung
m=10           #Masse in kg
tmax = 50      #Simulationsdauer
g = 9.81       #m/s^2
w02=g/l  #Quadrat der Kreisfrequenz       
#Lösung der DGL mit dem Euler-Verfahren
dt = 1e-3 #Schrittweite
phi,w=np.radians(winkel), 0.0  #Anfangswerte
t = np.arange(0, tmax, dt)
x,y = np.empty((len(t))),np.empty((len(t)))
v=np.empty((len(t)))
x[0]=y[0]=0
for i in range(len(t)):
    phi = phi + w*dt           #Auslenkung
    w = w - w02*np.sin(phi)*dt - d*w*dt
    v[i]=l*w
    x[i],y[i] = l*np.sin(phi),-l*np.cos(phi) #x-y-Koordinaten
#Animationsfunktion
def pendel(j):
    h=l+y[j]
    Epot=m*g*h
    Ekin=m*v[j]**2/2.0
    txtEpot.set_text(r'$E_{pot}$ = %.1f J' %Epot)
    txtEkin.set_text(r'$E_{kin}$ = %.1f J' %Ekin)
    stange.set_data([0,x[j]],[0, y[j]])
    kugel.set_data([x[j]],[y[j]])
    return stange,kugel,txtEpot,txtEkin
#Grafikbereich
fig,ax= plt.subplots(figsize=(6, 6))
txtEpot=ax.text(-l,l,'',fontsize=12)
txtEkin=ax.text(-l,0.85,'',fontsize=12)
ival=1e3*dt
n=len(y)-1
breite=1.1*l
ax.axis([-breite,breite,-breite,breite])
ax.set(xlabel='x',ylabel='y')
ax.set_aspect('equal')
ax.plot(0,0,'ko') #Lager
stange, = ax.plot([],[], 'b-', lw=1) #Stange
kugel, =  ax.plot([],[], 'ro', markersize='15') #Kugel
ani=FuncAnimation(fig, pendel,frames=n,interval=ival,blit=True)
plt.show()

'''
fig.savefig('04_038.png')
fig.savefig('04_038.svg')
'''

