#07_function4.py
rho=7.85    #kg/dm^3, density of steel

def volume(d,l):
    return 0.785*d**2*l

def mass(d,l):
    return rho*volume(d,l)

def moment_of_inertia(d,l):
    return 0.5*mass(d,l)*(d/2/10)**2

def acceleration_torque(d,l,alpha):
    return alpha*moment_of_inertia(d,l)

d1=1             #dm
l1=10            #dm
alpha1=1.2       #1/s^2, angular acceleration 
V=volume(d1,l1)
m=mass(d1,l1)
J=moment_of_inertia(d1,l1)
Mb=acceleration_torque(d1,l1,alpha1)
print("Volume:              ", V, " dm^3")
print("Mass:                ", m, " kg")
print("moment of inertia:   ", J, " kgm^2")
print("Acceleration torque: ", Mb, " Nm")
