#29_oop.py
class Cylinder:
    rho=7.85
    def __init__(self,diameter,length,alpha):
        self.__d=diameter #private
        self.__l=length   #private
        self.__a=alpha    #private
          
    def volume(self):
        return 0.785*self.__d**2*self.__l
    
    def mass(self):
        return self.rho*self.volume()
    
    def moment_of_inertia(self):
        return 0.5*self.mass()*(self.__d/2/10)**2
    
    def accelerationtorque(self):
        return self.__a*self.moment_of_inertia()
#Main program d and l in dm     
z=Cylinder(1,10,1.2)
#Cylinder.rho=2.3
#z.__d=100
print("Volume:",z.volume(),"dm^3")
print("Mass:  ",z.mass(),"kg")
print("Moment of inertia:  ",z.moment_of_inertia(),"kgm^2")
print("Acceleration torque:",z.accelerationtorque(),"Nm")
