#L_02_10.py
class Volume:
    def __init__(self,diameter,length):
        self.d=diameter
        self.l=length
        
    def volume(self):
        return 0.785*self.l*self.d**2
    
class Mass(Volume):   
    def __init__(self,rho,diameter,length):
        super().__init__(diameter,length)
        self.r=rho
        
    def mass(self):
        return Volume.volume(self)*self.r

class Moment_of_inertia(Mass):
    def __init__(self,rho,diameter,length):
        super().__init__(rho,diameter,length)
    
    def moment_of_inertia(self):
        return Mass.mass(self)*self.d**2/8/100

class Acceleration_torque(Moment_of_inertia):
    def __init__(self,rho,diameter,length,alpha):
        self.a=alpha
        super().__init__(rho,diameter,length)
    
    def acceleration_torque(self):
        return Moment_of_inertia.moment_of_inertia(self)*self.a

#main
d=1           #diameter in dm
l=10          #length in dm
rho1=7.86     #density kg/dm^3
alpha1=1.2    #Angular acceleration 1/s^2
V=Volume(d,l)
m=Mass(rho1,d,l)
J=Moment_of_inertia(rho1,d,l)
Mb=Acceleration_torque(rho1,d,l,alpha1)
print("Volume:",V.volume()," m^3")
print("Mass:",m.mass()," kg")
print("Moment of inertia:",J.moment_of_inertia()," kgm^2")
print("Acceleration torque:",Mb.acceleration_torque()," Nm")


