#02_runtime_comparison.py
import time as t
import numpy as np
#Python list
def version1(n):
    t1=t.time()
    x1=list(range(n)) #generate list
    x2=list(range(n))
    sum=[]
    for i in range(n):
        sum.append(x1[i]+x2[i])
    return t.time() - t1    
#NumPy arange()
def version2(n):
    t1=t.time()
    x1=np.arange(n)
    x2=np.arange(n)
    sum=x1+x2
    return t.time() - t1
#NumPy linspace()
def version3(n):
    t1=t.time()
    x1=np.linspace(0,n,n)
    x2=np.linspace(0,n,n)
    sum=x1+x2
    return t.time() - t1

nt=1000000
runtime1=version1(nt)
runtime2=version2(nt)
runtime3=version3(nt)
factor1=runtime1/runtime2
factor2=runtime1/runtime3
#Output
print("Runtime for Python range()...:",runtime1)
print("Runtime for NumPy  arange()..:",runtime2)
print("Runtime for NumPy linspace():",runtime3)
print("arange()   is%4d times faster than range()" %factor1)
print("linspace() is%4d times faster than range()" %factor2)
