#18_project_lightning_protection.py
import numpy as np
Iq=1e5 #current of the lightning in A
g=10   #conductance for steel S*m/mm^2
A=50   #conductor cross section in mm^2
l=10   #length in m
b=5    #width in m
h=3    #height in m
Gh=g*A/h   #conductance for height in S
Gl=g*A/l   #conductance for length in S
Gb=g*A/b   #conductance for width in S
G=np.array([[Gb+Gh+Gl, -Gl, -Gb, 0],
            [-Gl, Gb+Gh+Gl, 0,-Gb],
            [-Gb, 0, Gb+Gh+Gl,-Gl],
            [ 0,-Gb,-Gl, Gb+Gh+Gl]])
I=np.array([Iq,0,0,0])
U=np.linalg.solve(G,I)
I10=U[0]*Gh
I20=U[1]*Gh
I30=U[2]*Gh
I40=U[3]*Gh
I12=(U[0]-U[1])*Gl
I13=(U[0]-U[2])*Gb
I34=(U[2]-U[3])*Gl
I24=(U[1]-U[3])*Gb
print("--Voltage drops of down conductors--")
print("Voltage U10: %3.2f V" %U[0])
print("Voltage U20: %3.2f V" %U[1])
print("Voltage U30: %3.2f V" %U[2])
print("Voltage U40: %3.2f V" %U[3])
print("--Currents in down conductors--")
print("Current I10: %3.2f A" %I10)
print("Current I20: %3.2f A" %I20)
print("Current I30: %3.2f A" %I30)
print("Current I40: %3.2f A" %I40)
print("--Currents in lightning conductors--")
print("Current I12: %3.2f A" %I12)
print("Current I13: %3.2f A" %I13)
print("Current I34: %3.2f A" %I34)
print("Current I24: %3.2f A" %I24)

