#04_labels_legend.py
import numpy as np
import matplotlib.pyplot as plt
t=np.arange(0,20,0.001)
Ueff=[230,230]
u=325*np.sin(2*np.pi*50*t*1e-3)
fig, ax = plt.subplots()
ax.plot(t,u,'b',lw=2,label='Instantaneous value: u(t)')
ax.plot([0,20],Ueff,'r--',label='RMS value: 230V')
ax.plot(5,325,'ro',label='Peak value:325V')
ax.set(xlabel='t in ms',ylabel='u(t) in V',title='50 Hz AC voltage')
#ax.legend(loc='upper right')
#ax.legend(loc='lower left')
ax.legend(loc='best')
ax.grid(color='g',ls='dashed',lw='0.5')
plt.show()

