#16_subplot_polar_sinus.py
import numpy as np
import matplotlib.pyplot as plt

def theta_rad(angle1,angle2):
    theta=[angle1,angle2]
    return np.radians(theta)

angle=45
x=np.linspace(0, 360, 500)
y=np.sin(np.pi*x/180)
r=[np.cos(np.radians(angle)),1]
fig=plt.figure(figsize=(8,4))
#Polar coordinates
ax1=fig.add_subplot(1,2,1,projection='polar')
ax1.set_rticks([])
ax1.plot(theta_rad(0,angle),[0,1],'b',lw=2)
ax1.plot(theta_rad(0,angle),r,'b',lw=2)
ax1.plot(theta_rad(0,angle),[0,1],'ro')
ax1.grid(True)
#Cartesian coordinates
ax2=fig.add_subplot(1,2,2)
ax2.spines[['top', 'right']].set_visible(False)
ax2.spines[['bottom', 'left']].set_position(('data',0))
ax2.plot(x, y,'b',linewidth=2)
ax2.plot(angle,np.sin(np.radians(angle)),'ro')
ax2.plot(0,np.sin(np.radians(0)),'ro')
wg=[]
for w in range(0,361,45):
    wg.append(w)
ax2.set_xticks(wg[1:])
ax2.set_xlabel('x in °',loc='right')
ax2.set_ylabel('f(x)',loc='top',rotation=0)
plt.show()
