#17_parameter_throw.py
import numpy as np
import matplotlib.pyplot as plt
g=9.81   #Gravitational acceleration in m/s^2
v0=20    #Initial velocity in m/s
alpha=45 #Throwing angle in °
alpha=np.radians(alpha)
tmax=2*v0*np.sin(alpha)/g
t=np.linspace(0,tmax,100)
#Parameter equations
x=v0*np.cos(alpha)*t
y=v0*np.sin(alpha)*t-0.5*g*t**2
#Representation
fig, ax=plt.subplots()
ax.plot(x,y,linewidth=2)
ax.set(xlabel='x in m',ylabel='y in m')
ax.grid(True)
plt.show()
