#19_slider_sinus.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider,Button
fig,ax=plt.subplots()
fig.subplots_adjust(left=0.2,bottom=0.25)
t=np.linspace(0.0,1.0,200)
a0=5
f0=5
s=a0*np.sin(2*np.pi*f0*t)
kurve, = ax.plot(t,s,lw=2,color='blue')
ax.axis([0, 1, -10, 10])
#Position objects for controls
#left margin, bottom margin, length, height
xyAmp =  fig.add_axes([0.25, 0.15, 0.65, 0.03])
xyFreq = fig.add_axes([0.25, 0.1, 0.65, 0.03])
xyReset= fig.add_axes([0.8,0.025,0.1,0.04])
#Create objects for controls
sldAmp=Slider(xyAmp,'Amplitude',1,10,valinit=a0,valstep=0.1)
sldFreq=Slider(xyFreq,'Frequency',1,10,valinit=f0,valstep=0.1)
cmdReset=Button(xyReset,'Reset')

def update(val):
    A = sldAmp.val
    f = sldFreq.val
    kurve.set_data(t,A*np.sin(2*np.pi*f*t))

def reset(event):
    sldFreq.reset()
    sldAmp.reset()
#Event processing
sldAmp.on_changed(update)
sldFreq.on_changed(update)
cmdReset.on_clicked(reset)
plt.show()
'''
#19_slider_sinus.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider,Button
#query slider
def update(val):
    A = sldAmp.val
    f = sldFreq.val
    kurve.set_data(t,A*np.sin(2*np.pi*f*t))
#
def reset(event):
    sldFreq.reset()
    sldAmp.reset()
#Graphics area
fig,ax=plt.subplots()
fig.subplots_adjust(left=0.2,bottom=0.25)
t=np.linspace(0.0,1.0,200)
a0=5
f0=5
s=a0*np.sin(2*np.pi*f0*t)
kurve, = ax.plot(t,s,lw=2,color='blue')
ax.axis([0, 1, -10, 10])
#Position objects for controls
#left margin, bottom margin, length, height
xyAmp =  fig.add_axes([0.25, 0.15, 0.65, 0.03])
xyFreq = fig.add_axes([0.25, 0.1, 0.65, 0.03])
xyReset= fig.add_axes([0.8,0.025,0.1,0.04])
#Create objects for controls
sldAmp=Slider(xyAmp,'Amplitude',1,10,valinit=a0,valstep=0.1)
sldFreq=Slider(xyFreq,'Frequency',1,10,valinit=f0,valstep=0.1)
cmdReset=Button(xyReset,'Reset')
#Event processing
sldAmp.on_changed(update)
sldFreq.on_changed(update)
cmdReset.on_clicked(reset)
plt.show()
'''