#20_sld_phase_angle_control.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
Us=325     #peak value in V
a0=np.pi/4 #initial value 45°
xmax=np.pi
#u(x), x is an angle
def u(x):
    return Us*np.sin(x)
#query slider
def update(val):
    alpha = sldAlpha.val #control angle in °
    a=np.radians(alpha)  #control angle in rad
    x = np.arange(a,xmax,0.01)
    y.set_data(x,u(x))
    line.set_data([a,a],[u(0),u(a)])
    Uav=Us*(1.0 + np.cos(a))/np.pi
    txtAngle.set_text(r'$\alpha$ = %.2f °' %alpha)
    txtUav.set_text(r'$U_{av}$ = %.2f V' %Uav)
#Graphics area
fig, ax = plt.subplots()
txtAngle=ax.text(0.1,1.12*Us,r'$\alpha$ = %.2f °' %45)
txtUav=ax.text(0.1,1.05*Us,r'$U_{av}$ = 176.60 V')
fig.subplots_adjust(left=0.12,bottom=0.15)
ax.set_xlim(0,xmax)
ax.set_ylim(0,1.2*Us)
x0 = np.arange(a0,xmax,0.01) #for initial values
line, = ax.plot([a0,a0],[u(0),u(a0)],'b-')
y, = ax.plot(x0,u(x0),'b-')
xyAlpha = fig.add_axes([0.1, 0.02, 0.8, 0.03])
sldAlpha=Slider(xyAlpha,r'$\alpha$',0,180,valinit=np.degrees(a0),
valstep=1)
sldAlpha.on_changed(update)
ax.set(xlabel=r'$\alpha \  in\  rad$',ylabel='U in V')
secax = ax.secondary_xaxis('top',functions=(lambda x:10*x/np.pi,
lambda x:np.pi*x))
secax.set_xlabel('t in ms')
plt.show()
