#25_3d_mountain.py
import numpy as np
import matplotlib.pyplot as plt
width=10
h=100
x=y=np.linspace(-width,width,100)
x,y=np.meshgrid(x,y)
#Equation for paraboloid
z=h-x**2-y**2
#Show paraboloid
fig=plt.figure(figsize=(4.2,8))
ax1=fig.add_subplot(2,1,1,projection='3d')
ax1.plot_surface(x,y,z,rstride=5,cstride=5,color='g',edgecolors='y')
ax1.set_zlim(-h,h)
ax1.set(xlabel='x',ylabel='y',zlabel='z',title='Paraboloid')
#Level lines
ax2=fig.add_subplot(2,1,2)
hl=ax2.contour(x,y,z,levels=10,colors='b')
ax2.clabel(hl,inline=True)
ax2.set_xlim(-width,width)
ax2.set_ylim(-width,width)
ax2.set(xlabel='x',ylabel='y',title='Level lines')
ax2.set_aspect('equal')
plt.show()
