#30_pointer_diagram.py
import matplotlib.pyplot as plt
x1,x2=0,12
y1,y2=0,8
lb=2   #line width
pb=0.5 #arrow width
pl=1   #arrow length
U_R=10 #ohmic voltage drop
U_L=5  #inductive voltage drop
I=12   #current
fig,ax=plt.subplots()
ax.axis([x1,x2,y1,y2])
#Arrows: x,y,x+dx,y+dy
ax.arrow(0,1.8,I,0,color='r',lw=lb,length_includes_head=True,
         head_width=pb,head_length=pl)
ax.arrow(0,2,U_R,0,color='b',lw=lb,length_includes_head=True,
         head_width=pb,head_length=pl)
ax.arrow(U_R,2,0,U_L,color='b',lw=lb,length_includes_head=True,
         head_width=pb,head_length=pl)
ax.arrow(0,2,U_R,U_L,color='b',lw=lb,length_includes_head=True,
         head_width=pb,head_length=pl)
#Labels
ax.annotate("$I$",xy=(5,1),xytext=(5,1),fontsize=12)
ax.annotate("$U_g$",xy=(5,5),xytext=(5,5.5),fontsize=12)
ax.annotate("$U_L$",xy=(10.5,4),xytext=(10.5,4),fontsize=12)
ax.annotate("$U_R$",xy=(5,3),xytext=(5,2.5),fontsize=12)
ax.set_xticks([])
ax.set_yticks([])
ax.set_frame_on(False)
ax.set_aspect('equal')
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/04_030.pdf")
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/04_030.svg")
'''
