#34_animation_throw.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
g=9.81
v0=10
throwing_angle=45
alpha=np.radians(throwing_angle)
tmax=2*v0*np.sin(alpha)/g
xmax=v0**2*np.sin(2*alpha)/g
ymax=v0**2*np.sin(alpha)**2/(2*g)
#Calculate trajectory
def throw(t):
    x = v0*np.cos(alpha)*t
    y = v0*np.sin(alpha)*t-0.5*g*t**2
    ball.set_data([x],[y])
    return ball,
#generate objects
fig,ax=plt.subplots()
ax.axis([0,xmax+0.5,0,ymax+0.5])
ball, = ax.plot([],[],'ro')
t=np.linspace(0,tmax,100)
ani=FuncAnimation(fig,throw,frames=t,interval=20,blit=True)
ax.set(xlabel="x in m",ylabel="y in m",title="Oblique throw")
plt.show()


