#35_animation_elipse.py
import numpy as np
import matplotlib as mlt
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Data
r1,r2=0.5,0.25   
a,b=8,4 #Ellipse axes
width=10
#Initialization
def init():
    planet.center=(1,2)
    ax.add_patch(planet)
    return planet,
#Trajectory calculation
def trajectory(t):
    x,y=a*np.cos(np.radians(t)),b*np.sin(np.radians(t)) 
    planet.center=(x,y)
    return planet,
#Graphics area
fig,ax=plt.subplots()
ax.axis([-width,width,-width,width])
planet= mlt.patches.Circle((0,0),radius=r2, color='blue')
star= mlt.patches.Circle((2.5,0),radius=r1, color='red')
ax.add_artist(star)
ani=FuncAnimation(fig,trajectory,
          init_func=init,frames=360,interval=20,blit=True)
ax.set_aspect('equal')
ax.set(xlabel='x',ylabel='y',title='elliptical orbit')
plt.show()
