#38_animation_thread_pendulum.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Data
l = 1.0        #pendulum length in m
angle = 60    #deflection angle
d = 0.0        #damping
m=10           #mass in kg
tmax = 50      #simulation duration
g = 9.81       #m/s^2
w02=g/l  #square of the circular frequency       
#solution of the differential equation using the Euler method
dt = 1e-3 #increment
phi,w=np.radians(angle), 0.0  #initial values
t = np.arange(0, tmax, dt)
x,y = np.empty((len(t))),np.empty((len(t)))
v=np.empty((len(t)))
x[0]=y[0]=0
for i in range(len(t)):
    phi = phi + w*dt           #deflection
    w = w - w02*np.sin(phi)*dt - d*w*dt
    v[i]=l*w
    x[i],y[i] = l*np.sin(phi),-l*np.cos(phi) #x-y coordinates
#Animation function
def pendulum(j):
    h=l+y[j]
    Epot=m*h
    Ekin=m*v[j]**2/2.0
    txtEpot.set_text(f'$E_{{pot}}$={Epot:3.1f} J')
    txtEkin.set_text(f'$E_{{kin}}$={Ekin:3.1f} J')
    rod.set_data([0,x[j]],[0,y[j]])
    sphere.set_data([x[j]],[y[j]])
    return rod,sphere,txtEpot,txtEkin
#Graphics area
fig,ax= plt.subplots(figsize=(6, 6))
txtEpot=ax.text(-l,l,'',fontsize=12)
txtEkin=ax.text(-l,0.85,'',fontsize=12)
ival=1e3*dt
n=len(y)-1
width=1.1*l
ax.axis([-width,width,-width,width])
ax.set(xlabel='x',ylabel='y')
ax.set_aspect('equal')
ax.plot(0,0,'ko') #bearing
rod, = ax.plot([],[], 'b-', lw=1) #rod
sphere, =  ax.plot([],[], 'ro', markersize='15') #sphere
ani = FuncAnimation(fig, pendulum,frames=n,interval=ival,blit=True)
plt.show()
