#39_animation_transmission.py
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.animation as ani
from matplotlib.patches import Polygon
m=0.5   #module
i=2     #transmission ratio
d1=8    #mean diameter
d2=i*d1
a=(d1+d2)/2
z1=d1/m #number of teeth
z2=i*z1
h=13*m/6 #tooth height
c=0.2*m  #tooth clearance
i=complex(0,i)
x1=1/7
x2=1/3
tooth_shape=np.array([-x2,-x1,x1,x2])
frames=60
xmax=-11/16*d2,22/16*d2
ymax=-10/16*d2,10/16*d2
#Function definition for a gear
def gear(d,z,h):
    r=d/2
    alpha=2*np.pi/z #angle range
    sector=tooth_shape*alpha
    gear_section=np.array([r-h/2,r+h/2,r+h/2,r-h/2])-c
    tooth=gear_section*np.exp(1j*sector)
    return np.outer(np.exp(1j*alpha*np.arange(z)),tooth).ravel('C')
#Create gear objects
zr1=gear(d1,z1,h)
zr2=gear(d2,z2,h)*np.exp(1j*np.pi/z2)
step=2*np.pi/(z2*frames)
fig=plt.figure(figsize=(6,4))
ax=fig.add_axes([-0.2,-0.1,1.2,1.2])
image=[] #empty list
for k in range(frames):
    zr1=zr1*np.exp(-i*step) #right turning
    zr2=zr2*np.exp(1j*step) #left turning
    P1=Polygon(zr1.view(float).reshape(zr1.size,2),color='grey')
    P2=Polygon(zr2.view(float).reshape(zr2.size,2)+[a,0],color='k')
    image.append([ax.add_patch(P1),ax.add_patch(P2)])
an=ani.ArtistAnimation(fig,image,interval=20)
ax.set_aspect("equal")
ax.set_xlim(xmax)
ax.set_ylim(ymax)
plt.show()
