#L_04_03.py
'''Gas consumption'''
import numpy as np
import matplotlib.pyplot as plt
days=['Mon','Tue','Wed','Thu','Fri','Sat','Sun']#List
n=len(days)#Determine the number of elements in the list
x=np.arange(1,n,1) #Value range for days
consumption=[4,7,5,6,8,4,9] #Create consumption as a list
mw=np.mean(consumption)     #Calculate average
summe=np.sum(consumption)   #Calculate total for consumption
fig,ax = plt.subplots()     #create a Figure and an Axes object
ax.plot(consumption,'ro')   #draw red dots
ax.plot(consumption,'b-',label='Consumption')#draw a blue line
ax.plot([0,n],[mw,mw],'r-.',label='Average')#draw a horizontal line
ax.set(ylabel='Consumption in $m^{3}$',title='Gas consumption')
ax.set_xticks(np.arange(n),days)#Label x-axis
ax.legend(loc='best')         #Place legend
txtS=ax.text(-0.2,8,'summe')  #Create text object for sum
txtM=ax.text(-0.2,7.7,'mw')   #text object generate mean value
txtS.set_text(f'Consumption={summe:3.2f} $m^{3}$')#Show result for consumption
txtM.set_text(f'Average={mw:3.2f} $m^{3}$')       #Show result for mean
plt.show()