#L_04_05.py
#Subdiagrams among each other
import numpy as np
import matplotlib.pyplot as plt
L=0.1 #Inductance in H
C=2   #Capacity in F
f = np.linspace(0.1, 5, 1000) #Frequency range values
XL=2*np.pi*f*L     #Functional definition for inductive reactance
Xc=1/(2*np.pi*f*C) #Functional definition for capacitive reactance
fig, ax = plt.subplots(2)#ax object for 2 subgraphs
#inductance
ax[0].plot(f, XL,color="blue",linewidth=2)
ax[0].set(ylabel=r'$X_L$',title='inductive reactance')
ax[0].text(0.065,2.2,r'$X_{L}= \omega L$',fontsize=12)
ax[0].grid(True)
#capacity
ax[1].plot(f,Xc,color="red",linewidth=2)
ax[1].set(xlabel='f in Hz',ylabel=r'$X_c$',title='capacitive reactance')
ax[1].text(0.2,0.65,r'$X_{C}=\frac{1}{\omega C} $',fontsize=12)
ax[1].grid(True)
fig.tight_layout()
plt.show()
