#L_04_13.py
'''Simulation of a Fourier synthesis for a square oscillation'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
N=50 #maximum number of harmonics
xmax=4*np.pi
#Fourier synthesis
def fourier(x,n):
    s=0 #for summing up the harmonics
    for k in range(1,n,2): #k must be an odd number
        y=10*np.sin(k*x)/k #Calculation rule for Fourier series
        s=s+y #Form the sum of the harmonics
    return s
#Query changes to the slider
def update(val):
    n=sldN.val 
    y.set_data(x,[fourier(x,n)]) 
#Graphics area
fig, ax = plt.subplots(figsize=(8,8))#800x800 Pixel
#Set character range: Values must be between 0 and 1
fig.subplots_adjust(left=0.13,bottom=0.2)
x=np.linspace(0,xmax,500) #x is an angle
ax.axis([0,xmax,-12,12])  #Define value range for axes
ax.set(xlabel='x',ylabel='amplitude',title='Fourier synthesis')
#x, y position, length, height of the slider
xyN  = fig.add_axes([0.1, 0.05,  0.8, 0.03])
#Create slider object sldN
sldN =Slider(xyN,'n',2,N,valinit=5,valstep=1) #Set the number of harmonics
#Initialization of the function plot with with initial values
y, = ax.plot(x,fourier(x,sldN.val),'b-',lw=1) 
#Make changes
sldN.on_changed(update)
plt.show() #show all




