#L_04_17.py
'''Point moves on sine curve'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
A=8 #amplitude
xmax,ymax=2*np.pi,10
#Trajectory curve
def f(t):
    y= A*np.sin(t)
    #y=-(t - np.pi)**2
    return y
#Path calculation for point
def bahn(t):
    yp=f(t)
    zeit=t
    txtZeit.set_text('t = %.1f' %zeit)
    punkt.set_data([t],[yp])
    return punkt,txtZeit
#Create objects
fig,ax=plt.subplots()
ax.axis([0,xmax,-ymax,ymax])
txtZeit=ax.text(0.2,9,'',fontsize=12)
punkt, = ax.plot([],[],'ro',ms=10) #Red point
t=np.linspace(0,xmax,500)
ax.plot(t,f(t)) #Trajectory curve
ani=FuncAnimation(fig,bahn,frames=t,interval=20,blit=True)
ax.set(xlabel='x',ylabel='y')
plt.show()


