#L_04_18.py
'''Earth and Mars move around the sun'''
import numpy as np
import matplotlib as mlt
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Data
phi0=30
a1,b1=14,10 #inner planet
a2,b2=18,15 #outer planet
w1=0.02     #inner planet
w2=0.01     #outer planet
width=20
#Function definitions
def init():
    earth.center = (0,0)
    mars.center = (0,0)
    ax.add_patch(earth)
    ax.add_patch(mars)
    return earth,mars

def planets(t):
    phi1 = w1*t
    phi2 = w2*t + np.pi/4
    x1 = a1*np.sin(phi1)
    y1 = b1*np.cos(phi1)
    x2 = a2*np.sin(phi2)
    y2 = b2*np.cos(phi2)
    earth.center = (x1,y1)
    mars.center = (x2,y2)
    return earth,mars
#Graphics area
fig, ax = plt.subplots()
ax.axis([-width, width,-width,width])
sun= mlt.patches.Circle((0,0),radius=2.0,color='y')
ax.add_artist(sun)
earth = mlt.patches.Circle((0,0),radius=0.8, color='b')
mars = mlt.patches.Circle((0,0),radius=0.4, color='r')
#Animation
t=np.linspace(0,100,500)
anim = FuncAnimation(fig,planets, 
                        init_func=init, 
                        #frames=t, 
                        interval=20,
                        blit=True,
                        save_count=50
                     )
ax.set_aspect('equal')
plt.show()