#L_04_19.py
'''Moon-Earth-Sun rotation system'''
import numpy as np
import matplotlib as mlt
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Data
phi0=30
a1,b1=14,10 #earth
a2,b2=3,3   #moon
w1=0.02     #earth
w2=0.05     #moon
breite=20
#Function definitions
def init():
    earth.center = (0,0)
    moon.center = (0,0)
    ax.add_patch(earth)
    ax.add_patch(moon)
    return earth,moon

def moon_earth(t):
    phi1 = w1*t
    phi2 = w2*t + np.pi/4
    x1 = a1*np.sin(phi1)
    y1 = b1*np.cos(phi1)
    x2 = a2*np.sin(phi2)
    y2 = b2*np.cos(phi2)
    earth.center = (x1,y1)
    moon.center = (x1+x2,y1+y2)
    return earth,moon
#Graphics area
fig, ax = plt.subplots(figsize=(6,6))
ax.axis([-breite, breite,-breite,breite])
sun= mlt.patches.Circle((0,0),radius=2.0,color='y')
ax.add_artist(sun)
earth= mlt.patches.Circle((0,0),radius=0.8, color='b')
moon = mlt.patches.Circle((0,0),radius=0.4, color='r')
#animation
t=np.linspace(0,100,1000)
anim = FuncAnimation(fig,moon_earth, 
                    init_func=init, 
                    #frames=t, 
                    interval=100,
                    blit=True,
                    save_count=500
                     )
ax.set_aspect('equal')
plt.show()
