#25_integral3.py
from sympy import *
t = symbols('t')
U0=10
R,C =1,1
I0=U0/R
tau=R*C
uc=U0*(1-exp(-t/tau))     #voltage curve
ic=I0*exp(-t/tau)         #current curve
p=uc*ic                   #electrical power
Wel=integrate(p,(t,0,oo)) #electrical energy
#Output
print("Stored el. energy:",Wel.evalf(3),"Ws")
plt=plot(uc,ic,p,(t,0,5*tau),show=False,legend=True)
plt[0].line_color = 'b'
plt[0].label='Voltage'
plt[1].line_color = 'r'
plt[1].label='Current'
plt[2].line_color = 'g'
plt[2].label='Power'
#plt.save('power.png')
plt.show()
