#28_differential_equation_special_solution.py
from sympy import *
t=symbols("t")
uc=Function("uc")
U1=10
R=2
L=1/2
C=1/4
Us=U1/(L*C)      #perturbation function
w0=sqrt(1/(L*C)) #angular frequency
D=R/(2*L*w0)     #damping
dgl=Eq(uc(t).diff(t,2)+2*D*w0*uc(t).diff(t,1)+w0**2*uc(t),Us)
#initial values
aw={uc(0):0, uc(t).diff(t,1).subs(t,0):0}
ua_t=dsolve(dgl,uc(t))  #general solution
us_t=dsolve(dgl,uc(t),ics=aw)#special solution
uc_t=us_t.rhs
plot(uc_t,(t,0,5))
#Output
print("general solution\n",ua_t)
print("special solution\n",us_t)
print("right side of function uc(t) =",uc_t)
