#32_bending_line.py
from sympy import *
F,Iy,E,l=symbols('F,Iy,E,l')
x = symbols('x')
w = Function('w')(x)
#Inputs
b=20   #width in mm
h=30   #height in mm
lx=1e3 #length in mm
Fz=1e2 #force in N
#solution of the differential equation
dgl=Eq(w.diff(x,2),F/(E*Iy)*(l-x))
aL=dsolve(dgl)        #general solution of the differential equation
rb={                  #boundary conditions
    w.subs(x,0):0, 
    w.diff(x,1).subs(x,0):0
    }                 
sL=dsolve(dgl,ics=rb) #special solution
rL=sL.rhs             #right-hand side of the equation
mL=sL.rhs.subs(x,l)   
wmax=mL.subs(F,Fz).subs(l,lx).subs(E,2.1e5).subs(Iy,b*h**3/12)
wx=rL.subs(F,Fz).subs(l,lx).subs(E,2.1e5).subs(Iy,b*h**3/12)
#Outputs
print("Width b =",b, "mm")
print("Height h =",h, "mm")
print("Length l =",lx, "mm")
print("Force F =",Fz, "N")
print("General solution\n",aL)
print("Special solution\n",sL)
print("Right-hand side of the equation\n w(x) =",rL)
print(" w(x) =",wx)
print("Maximum deflection\n w(x=l) =",mL,"=",N(wmax,3),"mm")
p=plot(wx,(x,0,lx),ylabel='w(x)',show=False)
#p.save('bending_line.png')
#p.save('bending_line.svg')
p.show()
