#33_differential_equation_system.py
from sympy import symbols,Eq,Function,plot,N
from sympy.solvers.ode.systems import dsolve_system
t = symbols("t")
cA = Function("cA") #mol/dm^3
cB = Function("cB")
cC = Function("cC")
k1=0.0295     #1/min, U in Np
k2=2.0483e-4  #1/min, Np in Pu
#differential equation system
dgl1=Eq(cA(t).diff(t,1),-k1*cA(t)) #reactant
dgl2=Eq(cB(t).diff(t,1), k1*cA(t)-k2*cB(t)) #intermediate
dgl3=Eq(cC(t).diff(t,1), k2*cB(t)) #product
#initial values
aw={
    cA(0): 1,
    cB(0): 0,
    cC(0): 0
    }
#Solution of the differential equation system
equations = [dgl1,dgl2,dgl3]
aL=dsolve_system(equations)        #general solution
sL=dsolve_system(equations,ics=aw) #special solution
gA=sL[0][0].rhs #reactant
gB=sL[0][1].rhs #intermediate
gC=sL[0][2].rhs #product
#Outputs
print("General solution\n",aL)
print("Special solution")
print("cA(t) =",N(gA,3))
print("cB(t) =",N(gB,3))
print("cC(t) =",N(gC,3))
p=plot(gA,gB,gC,(t,0,600),show=False,legend=True)
p.title='Consecutive reaction'
p.xlabel='t in min'
p.ylabel='Concentration'
p[0].line_color='blue'
p[0].label='Uranium'
p[1].line_color='green'
p[1].label='Neptunium'
p[2].line_color='red'
p[2].label='Plutonium'
p.show()

'''
p.save('/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/05_017.pdf')
p.save('/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/05_017.svg')
'''
