#34_differential_equation_dual_mass_oscillator.py
from sympy import symbols,Eq,Function,plot,N
from sympy.solvers.ode.systems import dsolve_system
t = symbols("t")
x1 = Function("x1")(t)
x2 = Function("x2")(t)
m=1000 #kg
c=1e7  #N/m
d=1e3  #kg/s
m1,m2=m,2*m
c1,c2,c3=c,c,c
d1,d2,d3=d,d,d 
#differential equation system
dgl1=Eq(m1*x1.diff(t,2)+d1*x1.diff(t,1)+d2*(x1.diff(t,1)\
        -x2.diff(t,1))+c1*x1+c2*(x1-x2),0) 
dgl2=Eq(m2*x2.diff(t,2)+d2*(x2.diff(t,1)-x1.diff(t,1))\
        +d3*x2.diff(t,1)+c2*(x2-x1)+c3*x2,0)
#initial values
aw={
    x1.subs(t,0): 0.01, #m
    x2.subs(t,0): 0,
    x1.diff(t,1).subs(t,0):0,
    x2.diff(t,1).subs(t,0):0
    }
#Solution of the differential equation system
equations = [dgl1,dgl2]
aL=dsolve_system(equations)        #general solution
sL=dsolve_system(equations,ics=aw) #special solution
gX1=sL[0][0].rhs #deflection for m1
gX2=sL[0][1].rhs #deflection for m2
#Outputs
#print("General solution\n",aL)
#print("Special solution")
#print("x1(t) =",N(gX1,3))
#print("x2(t) =",N(gX2,3))
p=plot(gX1,gX2,(t,0,0.2),show=False,legend=True)
p.xlabel='t'
p.ylabel='Deflection in m'
p[0].line_color='blue'
p[0].label='x1'
p[1].line_color='red'
p[1].label='x2'
p.show()

'''
p.save('/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/05_019.pdf')
p.save('/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/05_019.svg')
'''
