#02_minimum.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import minimize
V=1 #volume

def f(r):
    h=V/(np.pi*r**2)
    A=2*np.pi*r**2+2*np.pi*r*h
    return A

x = np.linspace(0.1, 2, 100)
opt=minimize(f,0.5)
#Output
print("r=%4.6f A=%4.6f" %(opt.x[0],opt.fun))
fig, ax = plt.subplots()
ax.plot(x,f(x),"b-",lw=2)
ax.plot(opt.x[0],opt.fun,"rx",lw=2)
ax.set(xlabel="Radius",ylabel="Surface")
ax.grid(True)
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/06_002.pdf")
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/06_002.svg")
'''