#03_interpolation.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.interpolate import interp1d
ta=np.arange(0,12)
ti=np.arange(0,11,0.01)
#sampled signal
s=np.sin(ta)
#interpolation methods
#linear,next,previous,quadratic,cubic
f = interp1d(ta, s, kind='cubic')
fig, ax = plt.subplots()
ax.plot(ta,s, 'rx')    #points
ax.plot(ti,f(ti),'b-') #interpolated
ax.set(xlabel='Time', ylabel='Signal')
plt.show()
