#04_slope1.py
import numpy as np
from numdifftools import Derivative
#Function
def f(x):
    return 0.25*x**2
#central difference quotient
def df(x,h):
    return (f(x+h)-f(x-h))/(2*h)

xs=2   #place of the slope
h=1e-6 #accuracy
mS=df(xs,h) #secant slope
mT=Derivative(f,n=1) #tangent slope
a1=np.degrees(np.arctan(mS))
a2=np.degrees(np.arctan(mT(xs)))
print("Secant slope  m=%2.6f %s=%2.1f°"%(mS,chr(945),a1))
print("Tangent slope m=%2.6f %s=%2.1f°"%(mT(xs),chr(945),a2))
