#05_slope2.py
import numpy as np
import matplotlib.pyplot as plt
from numdifftools import Derivative
#Function
def f(x):
    return x**2/2
#Tangent
def f2(x,xs):
    m=Derivative(f,n=1)
    x0=xs-f(xs)/m(xs)
    return m(xs)*(x-x0)

x = np.linspace(0, 5, 100)
xs=2 #place of the slope
fig, ax = plt.subplots()
ax.plot(x, f(x),"g-", lw=2) #function
ax.plot(x, f2(x,xs),"b-", lw=1) #tangent
ax.plot(xs, f(xs), "or") #red point
ax.set(xlabel="x",ylabel="y")
ax.grid(True)
plt.show()
