#10_constant_integration1.py
import numpy as np
import matplotlib.pyplot as plt
import scipy.integrate as integral
C=1 #F
imax=10
#Constant current source
@np.vectorize
def i(t):
    return imax
#Capacitor voltage
@np.vectorize
def u(t):
    uc=(1/C)*integral.quad(i,0,t)[0]
    return uc

x = np.linspace(0, 20, 500)
fig, (ax1,ax2)=plt.subplots(2,1)
ax1.plot(x, i(x), 'r-', lw=2)
ax1.set(ylabel='Current in A',title='Voltage at capacitor')
ax2.plot(x, u(x),'b-',lw=2)
ax2.set(xlabel='t in s',ylabel='$u_c(t)$ in V')
ax1.grid(True);ax2.grid(True)
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/06_011.pdf")
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/06_011.svg")
'''
