#11_constant_integration2.py
import numpy as np
import matplotlib.pyplot as plt
import scipy.integrate as integral
g=9.81
@np.vectorize
def a(t):
    return g
@np.vectorize
def v(t):
    return integral.quad(a, 0, t)[0]
@np.vectorize
def s(t):
    return integral.quad(v, 0, t)[0]
#time values
t = np.linspace(0,5,100)
fig, ax=plt.subplots(3,1,figsize=(6,8))
ax[0].plot(t, a(t), 'g-', lw=2)
ax[0].set(ylabel='a in $m/s^2$',title='Acceleration')
ax[0].set_ylim(0,12)
ax[1].plot(t, v(t), 'r-',lw=2)
ax[1].set(ylabel='v in m/s',title='Velocity')
ax[2].plot(t, s(t), 'b-', lw=2)
ax[2].set(xlabel='t in s',ylabel='s in m',title='Distance')
[ax[i].grid(True) for i in range(len(ax))]
fig.tight_layout()
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/06_012.pdf")
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/06_012.svg")
'''
