#14_integral7.py
import numpy as np
import scipy.integrate as integral
from numdifftools import Derivative
#function definition
def f(x):
    #return x
    return np.sqrt(x)
#square function f(x)
def f2(x):
    return f(x)**2
#for curved surface
def m(x):
    df=Derivative(f)
    return f(x)*np.sqrt(1+df(x)**2)
#limits
a,b=0,1
V=np.pi*integral.quad(f2,a,b)[0]  #volume
M=2*np.pi*integral.quad(m,a,b)[0] #curved surface
print("Volume      %3.6f" %V)
print("Curved surface %3.6f" %M)
