#16_triple_integral.py
import numpy as np
import scipy.integrate as integral
g=9.81     #gravitational acceleration
rho_0=1.28 #air density
p0=10e5    #air pressure
alpha=g*rho_0/p0

def density(z,x,y):
    return rho_0*np.exp(-alpha*z)
    
a=1 #x2
b=1 #y2
h=8.223e3 #z2 height of the air column in m
#mass of the air column
m1=a*b*rho_0*(1-np.exp(-alpha*h))/alpha
#x1,x2,y1,y2,z1,z2
m2=integral.tplquad(density,0,a,0,b,0,h)[0]
print("Mass of air column m1:",m1, "kg")
print("Mass of air column m2:",m2, "kg")
