#18_differential_equation_comparison.py
import numpy as np
from scipy.integrate import odeint,solve_ivp

def dgl(x,y):
    dy_dx=y*x
    return dy_dx

n=5
xmax=1
y0=[1]      #initial value
xi=[0,xmax] #integration range
x = np.linspace(0,xmax,n)
#solutions
y1 = np.exp(x**2/2)#exact
y2 = odeint(dgl,y0,x)
#methods for solve_ivp
#RK45, RK23, DOP853, Radau, BDF, LSODA
z = solve_ivp(dgl,xi,y0,method='RK45',dense_output=True)
y3 = z.sol(x)
#comparison
print("Exactly :",y1)
print("odeint:",y2.reshape(n,))
print("ivp   :",y3.reshape(n,))
