#19_differential_equation3.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
U0=10
R,L=1,1
Tau=L/R
tmax=5*Tau
ti=[0,tmax] #integration interval
IL0 =[0]    #initial value
#First-order differential equation
def dgl(t,ia):
    i=ia #initial value
    di_dt=(U0-R*i)/L
    return di_dt
#t.shape (500, )
t = np.linspace(0,tmax,500)
#solution of the differential equation
z = solve_ivp(dgl,ti,IL0,dense_output=True)
iL = z.sol(t) #iL.shape (1,500)
#Display of the solution
fig, ax = plt.subplots()
ax.plot(t, iL.flatten(),"r-",lw=2) #iL.flatten().shape (500, )    
ax.set(xlabel="t",ylabel="$I_L(t)$")
ax.grid(True)
plt.show()

