#20_differential_equation_second_order.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
U0 = 100  #input voltage in V
R = 1.5   #armature resistance in Ohms
L = 0.025 #armature inductance in H
Mn=150    #rated torque in Nm
In=50     #rated current in A
J=0.2     #moment of inertia in kgm^2
tmax=0.5  #time in seconds
#system of differential equations
def dgl(t,initial_values,R,L,C):
    uc,i = initial_values
    duc_dt = i/C
    di_dt = (U0 - R*C*duc_dt-uc)/L
    return [duc_dt, di_dt]

C = J*(In/Mn)**2 #dynamic capacitance
a0 = [0,0]       #initial values
ti=[0,tmax]      #integration interval
t = np.linspace(0,tmax,500)
z=solve_ivp(dgl,ti,a0,args=(R,L,C),dense_output=True)
uc,ic = z.sol(t)
fig,axes=plt.subplots(2,1,figsize=(6,6))
#capacitor voltage
axes[0].plot(t, uc,'b-',lw=2)
axes[0].set_title("Step response of a DC motor with separate excitation")
axes[0].set_ylabel('Output voltage in V')
#current_profile
axes[1].plot(t, ic,'r-',lw=2)
axes[1].set(xlabel='Time in seconds',ylabel='Armature current in A')
axes[0].grid(True);axes[1].grid(True)
print("Dynamic capacitance:",C, "F")
fig.tight_layout()
plt.show()
