#21_differential_equation_simple_pendulum.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
l=10        #length of the pendulum in m
d=1         #diameter of the sphere in dm
phi0=179    #deflection
cw=0.3      #drag coefficient for the sphere
rho_K=7.85  #density of steel kg/dm^2
rho_L=1.28  #Density of air kg/m^3
g=9.81      #gravitational acceleration
tmax=50
#system of differential equations
def dgl(t,ya,b,w02):
    phi, w = ya
    dphi_dt = w
    dw_dt = -b*np.abs(w)*w-w02*np.sin(phi)
    return [dphi_dt,dw_dt]
#computations
r=d/2                  #radius of the sphere in dm
A=np.pi*(0.1*r)**2     #circle area in m^2
m=rho_K*4/3*np.pi*r**3 #mass of the sphere in kg
b=cw*rho_L*A*l/(2*m)   #damping constant
w02=g/l
T=2.0*np.pi*np.sqrt(l/g)
f=1.0/T    #frequency
vmax=np.sqrt(2*g*l*(1-np.cos(np.radians(phi0))))
#solution of the differential equation
y0 = [np.radians(phi0),0]
t = np.linspace(0, tmax, 500)
z=solve_ivp(dgl,[0,tmax],y0,args=(b,w02),dense_output=True)
phi, w = z.sol(t) 
v=l*w
#Output
fig,ax=plt.subplots(2,1)
#Deflection
ax[0].plot(t, np.degrees(phi),'r-',lw=2)
ax[0].set(ylabel=r"$\varphi$ in °",title="Simple pendulum")
#Velocity
ax[1].plot(t, v,'b-',lw=2)
ax[1].set(xlabel='Time in s',ylabel="v in m/s")
[ax[i].grid(True) for i in range(len(ax))]
fig.tight_layout()
print("Mass of the sphere %3.2f kg"%m)
print("Period duration %3.2f s"%T)
print("Frequency %3.2f Hz"%f)
print("Damping %3.4f"%b)
print("Maximum velocity %3.2f m/s"%vmax)
plt.show()
