#22_differential_equation_two-mass_oscillator.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
m=1e3    #mass in kg
c=1e7    #spring constant N/m
d=1e3    #damping kg/s
m1,m2=m,2*m      
c1,c2,c3=c,2*c,3*c
d1,d2,d3=d,2*d,3*d 
tmax=0.2 #seconds
#system of differential equations
def dgl(t,xa,c1,c2,c3,d1,d2,d3,m1,m2):
    x1,v1,x2,v2=xa
    dx1_dt=v1
    dv1_dt=-(d1*v1+d2*(v1-v2)+c1*x1+c2*(x1-x2))/m1
    dx2_dt=v2
    dv2_dt=-(d3*v2+d2*(v2-v1)+c3*x2+c2*(x2-x1))/m2
    return np.array([dx1_dt,dv1_dt,dx2_dt,dv2_dt])
#Solution of the differential equation system
t = np.linspace(0,tmax,500)
x0 = [0.1, 0.0, 0.0, 0.0]#initial values
parameter=(c1,c2,c3,d1,d2,d3,m1,m2)
z=solve_ivp(dgl,[0,tmax],x0,args=parameter,dense_output=True)
x1,v1,x2,v2 = z.sol(t)
fig,ax=plt.subplots()
#deflection m1
ax.plot(t, 1e3*x1,'r-',lw=1.5,label=r'$m_{1}$')
#deflection m2
ax.plot(t, 1e3*x2,'b-',lw=1.5,label=r'$m_{2}$')
ax.legend()
ax.set(xlabel='t in s',ylabel='Deflection in mm')
ax.grid(True)
plt.show()
