#23_differential_equation_double_pendulum.py
import numpy as np
from numpy import sin,cos
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
#pendulum data
g = 9.81    #gravitational acceleration
l1,l2 = 2,1 #pendulum lengths
m1,m2 = 5,1 #pendulum masses
phi1, phi2 = 120, -10 #deflection
tmax=20
#system of differential equations
def dgl(t,ya,l1, l2, m1, m2):
    phi1,w1,phi2,w2 = ya
    delta=phi2-phi1; m=m1+m2 #abbreviation for angle and mass
    phi1_dt = w1 #1. Derivative top angle
    w1_dt=(m2*l1*w1**2*sin(delta)*cos(delta)\
      +m2*g*sin(phi2)*cos(delta)+m2*l2*w2**2*sin(delta)-m*g*sin(phi1))\
           /(m*l1-m2*l1*cos(delta)**2)
    phi2_dt = w2 #1. Derivative bottom angle
    w2_dt=(-m2*l2*w2**2*sin(delta)*cos(delta)\
       + m*(g*sin(phi1)*cos(delta)-l1*w1**2*sin(delta)-g*sin(phi2)))\
           /(m*l2-m2*l2*cos(delta)**2)
    return np.array([phi1_dt, w1_dt, phi2_dt, w2_dt])
#Solution of the differential equation system
omega1 = omega2 = 0
ya =[np.radians(phi1),omega1,np.radians(phi2),omega2]
t = np.linspace(0,tmax,1000)
z=solve_ivp(dgl,[0,tmax],ya,args=(l1,l2,m1,m2),dense_output=True)
phi1, w1, phi2, w2 = z.sol(t) #solutions
#calculation of the x,y coordinates, l1 is anchored in the origin
x1,y1 =    l1*sin(phi1),  -l1*cos(phi1) #1st pendulum 
x2,y2 = x1+l2*sin(phi2),y1-l2*cos(phi2) #2nd pendulum
fig, ax = plt.subplot_mosaic([['upper left', 'right'],
                              ['lower left', 'right']],
                              figsize=(8,4), layout="constrained")
#Deflection pendulum l1 (top)
width=1.1*(l1+l2)
ax['upper left'].plot(t,x1,'r-',lw=1)#x-direction top
ax['upper left'].plot(t,y1,'b-',lw=1)#y-direction top
ax['upper left'].set(ylabel='$x_1, y_1$',title='Pendulum 1')
#Deflection pendulum l2 (bottom)
ax['lower left'].plot(t,x2,'r-',lw=1) #x-direction bottom
ax['lower left'].plot(t,y2,'b-',lw=1) #y-direction bottom
ax['lower left'].set(xlabel='t',ylabel='$x_2, y_2$',title='Pendulum 2')
#Trajectories
width=1.1*(l1+l2)
ax['right'].plot(x1,y1,'r-',lw=1,label='Pendulum 1')
ax['right'].plot(x2,y2,'b-',lw=1,label='Pendulum 2')
ax['right'].set(xlabel='x',ylabel='y',title='Trajectories')
ax['right'].legend(loc='best')
ax['right'].set_xlim(-width,width)
ax['right'].set_ylim(-width,width)
plt.show()
