#25_fourier_rectangle.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.fft import fft,fftfreq  
f=50     #frequency in Hz
T=1/f    #period duration
umax=325 #amplitude
N=6000   #number of samplings
Ta=T/N   #sampling time
t=np.linspace(0,T,N)
#compute total harmonic distortion
def total_harmonic_distortion(u):
    z=0
    for i in range(1,len(u)):
        z=z+u[i]**2  
    return np.sqrt(z)/u[0]   
#rectangle function
@np.vectorize
def ur(t):
    if t < T/2:
        return umax
    else:
        return -umax
#sawtooth
@np.vectorize
def us(t):
    return 1e4*(t-T/2)
#triangle
@np.vectorize
def ud(t):
    m=100
    if t < T/2:
        return m*t
    else:
        return -m*(t-T/2)+m*T/2
#parabolic arcs
@np.vectorize
def up(t):
    if t < T/2:
        return -(t-T/4)**2+(T/4)**2
    else:
        return (t-3*T/4)**2-(T/4)**2
u_t=ur(t)
#transformation to the frequency domain 
U_fft = fft(u_t)
#magnitudes of the amplitudes in the frequency domain
U_f=2*np.abs(U_fft)/N
#compute harmonics
fk=fftfreq(N,Ta)
pos=np.where(fk>0) #only positive frequencies
#create subdiagrams
print("Total harmonic distortion %2.3f"%total_harmonic_distortion(U_f[pos]))
fig,ax=plt.subplots(2,1)
#display square wave display
ax[0].plot(1e3*t,u_t,"b-",lw=2)
ax[0].set(xlabel="t in ms",ylabel="U in V")
#display frequency spectrum
ax[1].stem(fk[pos],U_f[pos])
ax[1].set(xlabel="f in Hz",ylabel="Amplitudes")
ax[1].set_xlim(0,1000)
fig.tight_layout()
plt.show()
