#26_low-pass_filter.py
import numpy as np
from matplotlib import pyplot as plt
from scipy.fft import fft,ifft,fftfreq 
f=50     #frequency in Hz
T = 1/f  #period duration
fg=1.1*f #cutoff frequency
N=6000   #number of samplings
Ta=T/N   #sampling time
t = np.linspace(0,T,N)
u_t=10*np.sin(2*np.pi*f*t)+8*np.random.randn(t.size)
#transformation to the frequency domain
U_fft = fft(u_t)
#compute sampling frequency
fk = fftfreq(u_t.size,Ta)
#filter signal
F_g=U_fft*(np.abs(fk) < fg)
#transformation back to the time domain
u_g = ifft(F_g)
fig, ax=plt.subplots(2,1,figsize=(6,6))
#noisy signal
ax[0].plot(1e3*t, u_t)
ax[0].set(xlabel="t in ms",ylabel="u(t)",title="Noisy signal")
#filtered signal
ax[1].plot(1e3*t, u_g.real,lw=2)
ax[1].set(xlabel="t in ms",ylabel="u(t)",title="Filtered signal")
fig.tight_layout()
plt.show()
