#29_tp_frequency_response.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.signal import butter,freqs
g=3     #degree of the filter
fg=1    #cutoff frequency in Hz
#numerator, denominator coefficients
b,a=butter(g,fg,'lowpass',analog=True)
#angular frequency, frequency response
omega,h_t = freqs(b,a)
fig, ax=plt.subplots(figsize=(8,6))
ax.semilogx(omega, 20*np.log10(abs(h_t)))
#ax.plot(omega, 20*np.log10(abs(h_t)))
ax.set_title('Butterworth lowpass')
ax.set_xlabel('f in Hz')
ax.set_ylabel('Amplitude in dB')
ax.margins(0, 0.1)
ax.grid(which='both', axis='both')
ax.axvline(fg, color='red') #cutoff frequency
plt.show()
