#31_tpfilter.py
import numpy as np
import matplotlib.pyplot as plt
import scipy.signal as signal
g=10  #degree of the filter
f1=10
f2=30
fs=1e3    #sampling frequency
fg=1.1*f1 #cutoff frequency
tmaxes=1
t = np.linspace(0,tmaxes,2000)
u_t = np.sin(2*np.pi*f1*t) + np.sin(2*np.pi*f2*t)/3
#u_t = 10*np.sin(2*np.pi*f1*t) + 5*np.random.randn(t.size)
TPK = signal.butter(g,fg,'low',analog=False,output='sos',fs=fs)
filter = signal.sosfilt(TPK, u_t)
fig, ax = plt.subplots(2, 1)
#mixed signal
ax[0].plot(t, u_t)
ax[0].set(ylabel='u(t)',title='10-Hz und 30-Hz Signal')
#filtered signal
ax[1].plot(t, filter)
ax[1].set(xlabel='t in s',ylabel='u(t)',title='Filtered signal:10 Hz')
plt.tight_layout()
plt.show()
