#32_bearing_damage.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.fft import fft,fftfreq    
f1=20 #1200 1/min
fn=[f1,2*f1,3*f1,4*f1,5*f1]
a1=[4,5,4,3,2,1] #defect
a2=[4,0.22,0.21,0.15,0.11] #undamaged
#Frequency
T=20
N=5000
Ta=T/N #sampling time
t = np.linspace(0,T,N)
#noisy signals
ur = a1[0]*np.sin(2*np.pi*fn[0]*t)\
    +a1[1]*np.sin(2*np.pi*fn[1]*t)\
    +a1[2]*np.sin(2*np.pi*fn[2]*t)\
    +a1[3]*np.sin(2*np.pi*fn[3]*t)\
    +a1[4]*np.sin(2*np.pi*fn[4]*t)\
    +np.random.normal(size=N)

ug = a2[0]*np.sin(2*np.pi*fn[0]*t)\
    +a2[1]*np.sin(2*np.pi*fn[1]*t)\
    +a2[2]*np.sin(2*np.pi*fn[2]*t)\
    +a2[3]*np.sin(2*np.pi*fn[3]*t)\
    +a2[4]*np.sin(2*np.pi*fn[4]*t)\
    +np.random.normal(size=N)
#transformation to the frequency domain 
U_fftd = fft(ur) #defect
U_fftg = fft(ug)
fk=fftfreq(N,Ta)
pos=np.where(fk>0)
#amplitude magnitudes
Usd=2.0/N*np.abs(U_fftd) #defect
Usf=2.0/N*np.abs(U_fftg) 
#Frequency spectrum
fig,ax=plt.subplots(3,1,figsize=(6,6))
#Time domain
ax[0].plot(t,ur,"b-",lw=1)
ax[0].set_xlim(0,10)
ax[0].set(xlabel="t in s",ylabel="a",title="Noisy signal")
#damaged bearing
ax[1].plot(fk[pos],Usd[pos],"r-",lw=2)
ax[1].set(xlabel="f in Hz",ylabel="a",title="Damaged bearing")
#undamaged bearing
ax[2].plot(fk[pos],Usf[pos],"g-",lw=2)
ax[2].set(xlabel="f in Hz",ylabel="a",title="Undamaged bearing")
fig.tight_layout()
plt.show()
