#33_predator_prey.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
K1=10e3 #prey capacity limit
K2=1e3 #predator capacity limit
prey=500
predator=50
r=0.25   #prey reproduction rate
b=0.001  #prey probability
s=0.5    #predator mortality rate
c,d = r/K1, s/K2
tmax=50  #period
xy0=[prey,predator]
#system of differential equations
def dgl(t,xy,r,b,s,c,d):
    N1,N2 = xy   #initial values
    dN1_dt= r*N1-b*N1*N2-c*N1**2 #prey
    dN2_dt=-s*N2+b*N1*N2-d*N2**2 #predator
    return [dN1_dt,dN2_dt]
#Solution of the differential equation system
t = np.linspace(0,tmax,500)
z=solve_ivp(dgl,[0,tmax],xy0,args=(r,b,s,c,d),dense_output=True)
N1, N2 = z.sol(t) #separation of the solutions
mbmean=int(np.mean(N1)) #prey, mean value
mrmean=int(np.mean(N2)) #predator, mean value
fig,ax=plt.subplots(2,1,figsize=(6,6))
#time chart
ax[0].plot(t, N1,"g--",lw=2,label="Prey")
ax[0].plot(t, N2,"r-",lw=2,label="Predator")
ax[0].plot([0,tmax],[mbmean,mbmean],"g-.",lw=1)
ax[0].plot([0,tmax],[mrmean,mrmean],"r-.",lw=1)
ax[0].set(xlabel="Time",ylabel="$N_{1}, N_{2}$")
ax[0].legend(loc="best")
#phase diagram
ax[1].plot(N1, N2,'b-',lw=1)
ax[1].set(xlabel="Prey",ylabel="Predator",title="Phase diagram")
fig.tight_layout()
plt.show()

#fig.save('06_033.pdf')
