#34_epidemic.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
tmax=120
S0=997  #not immune healthy individuals
I0=3    #infected
R0=0    #recovered
N=S0+I0+R0 #Population
b=0.4  #infection rate
g=0.04 #recovery rate
#system of differential equations
def dgl(t,ya):
    S,I,R=ya
    dS_dt=-b*S*I/N    #not immune healthy individuals
    dI_dt=b*S*I/N-g*I #infected
    dR_dt=g*I         #recovered
    return [dS_dt,dI_dt,dR_dt]
#Initial values
y0 = [S0,I0,R0]
t = np.linspace(0, tmax, 500)
z=solve_ivp(dgl,[0,tmax],y0,dense_output=True)
S, I, R = z.sol(t)
fig, ax = plt.subplots()
ax.plot(t, S,'b-',label="Healthy")
ax.plot(t, I,'r--',label="Infected")
ax.plot(t, R,'g-.',label="Recovered")
ax.legend(loc='best')
ax.set(xlabel="Time",ylabel="Individuals")
ax.grid(True)
plt.show()


