#L_06_02.py
#Length of a log. spiral
import numpy as np
import scipy.integrate as integral
from numdifftools import Derivative
a=0.1  
b=0.5
#x is an angle
def r(x):
    return a*np.exp(b*x)

def dl(x): 
    df=Derivative(r,method='complex')
    return np.sqrt(r(x)**2 + df(x)**2)
#distances
phi1=0
phi2=2*np.pi
#length of the spiral
lg=np.sqrt(b**2+1)/b*(r(phi2)-r(phi1))#exactly
li=integral.quad(dl,phi1,phi2)[0]     #integrated
print("Length of a logarithmic spiral")
print("exactly:      ",lg)
print("integrated: ",li)
print("absolute error:",lg-li)


